﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//	Summary
// 		* GameObject의 Fade animation을 적용한다.

namespace GameUtility
{

	public class AnimationFade : MonoBehaviour
	{

		public float m_Duration	= 0.5f;
		// Animation duration.

		MeshRenderer _renderer;
		Color beginColor;
		Color endColor;
		bool isFadeOut;
		float m_time;

		// Use this for initialization
		void Start ()
		{
			_renderer	= GetComponent<MeshRenderer> ();

			beginColor	= _renderer.material.color;
			endColor	= new Color (0f, 0f, 0f, 0f);
			// endColor.a	= 0f;
			m_time = 0f;
		}
	
		// Update is called once per frame
		void Update ()
		{

			if (isFadeOut) {
				beginColor	= _renderer.material.color;
				endColor	= new Color (0f, 0f, 0f, 0f);

				Color newColor = Color.Lerp (beginColor, endColor, m_time / m_Duration);

				_renderer.material.color = newColor;

				m_time += Time.deltaTime;
			}
		}

		public void FadeOut ()
		{
			isFadeOut	= true;
		}
	}
}